/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright  2009 ParaType Ltd. All rights reserved.
 * 
 * Trademark:
 * PT Sans is a trademark of the ParaType Ltd.
 * 
 * Description:
 * PT Sans is a type family of universal use. It consists of 8 styles: regular and
 * bold weights with corresponding italics form a standard computer font family;
 * two narrow styles (regular and bold) are intended for documents that require
 * tight set; two caption styles (regular and bold) are for texts of small point
 * sizes. The design combines traditional conservative appearance with modern
 * trends of humanistic sans serif and characterized by enhanced legibility. These
 * features beside conventional use in business applications and printed stuff made
 * the fonts quite useable for direction and guide signs, schemes, screens of
 * information kiosks and other objects of urban visual communications.
 * 
 * The fonts next to standard Latin and Cyrillic character sets contain signs of
 * title languages of the national republics of Russian Federation and support the
 * most of the languages of neighboring countries. The fonts were developed and
 * released by ParaType in 2009 with financial support from Federal Agency of Print
 * and Mass Communications of Russian Federation. Design - Alexandra Korolkova with
 * assistance of Olga Umpeleva and supervision of Vladimir Yefimov.
 * 
 * Manufacturer:
 * ParaType Ltd
 * 
 * Designer:
 * A.Korolkova, O.Umpeleva, V.Yefimov
 * 
 * Vendor URL:
 * http://www.paratype.com
 */
Cufon.registerFont({"w":210,"face":{"font-family":"PT Sans","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 5 3 2 2 3 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-13 -313 352 84.6092","underline-thickness":"18","underline-position":"-18","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":96,"k":{"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,",":31,".":31,"\u2026":31,"T":11,"V":11,"W":7,"X":11,"Y":11,"\u00dd":11,"Z":8,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"z":11,"\u00c6":14,"\"":24,"'":24,"\u2018":24,"\u2019":24,"\u201c":24,"\u201d":24,"A":12,"\u00c0":12,"\u00c1":12,"\u00c2":12,"\u00c3":12,"\u00c4":12,"\u00c5":12}},"!":{"d":"46,-252r30,0v0,65,2,132,-7,188r-17,0v-8,-57,-6,-123,-6,-188xm60,4v-12,1,-20,-9,-20,-21v0,-12,8,-20,20,-20v12,0,22,8,21,20v1,13,-8,22,-21,21","w":109},"\"":{"d":"74,-252r28,0r-11,69r-17,0r0,-69xm32,-252r28,0r-11,69r-17,0r0,-69","w":120,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"v":-11,"y":-11,"\u00fd":-11,"\u00ff":-11,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"#":{"d":"108,-81r-38,0r-14,60r-25,0r14,-60r-28,0r5,-23r29,0r11,-47r-27,0r5,-23r27,0r14,-57r25,0r-14,57r38,0r14,-57r24,0r-13,57r28,0r-6,23r-28,0r-11,47r27,0r-6,23r-26,0r-14,60r-25,0xm76,-104r37,0r12,-47r-38,0"},"$":{"d":"141,-129v57,22,50,132,-22,132r0,33r-25,0r0,-32v-23,0,-45,-4,-59,-11r9,-26v13,6,29,10,50,11r0,-97v-29,-14,-58,-30,-58,-73v0,-38,22,-59,58,-63r0,-33r25,0r0,32v22,0,37,4,51,10r-9,25v-11,-5,-24,-9,-42,-9r0,89xm113,-22v41,-1,51,-64,15,-80v-5,-3,-10,-5,-15,-8r0,88xm100,-230v-32,-1,-45,41,-25,61v6,7,15,13,25,18r0,-79"},"%":{"d":"229,-257r18,14r-185,247r-18,-14xm81,-134v-38,0,-56,-23,-56,-61v0,-38,17,-61,56,-61v39,-1,56,23,56,61v0,38,-18,61,-56,61xm81,-235v-22,1,-29,13,-29,40v0,25,7,39,29,40v23,0,29,-16,29,-40v0,-24,-6,-40,-29,-40xm210,0v-38,0,-56,-23,-56,-61v0,-38,17,-61,56,-61v39,-1,56,23,56,61v0,38,-18,61,-56,61xm210,-101v-22,1,-29,13,-29,40v0,25,7,39,29,40v23,0,29,-16,29,-40v0,-24,-6,-40,-29,-40","w":278},"&":{"d":"204,-29v-37,49,-167,46,-162,-38v2,-46,31,-70,62,-89v-30,-31,-32,-100,31,-100v33,0,52,14,52,43v0,30,-23,47,-48,61v17,33,42,59,65,85v12,-15,22,-35,28,-56r23,11v-9,20,-21,46,-35,62v14,12,28,25,45,34r-18,20v-13,-6,-27,-17,-43,-33xm99,-123v-50,33,-24,122,48,100v17,-5,31,-12,40,-24v-27,-27,-49,-58,-70,-91xm136,-234v-38,0,-25,49,-9,66v19,-12,30,-22,34,-40v0,-16,-9,-26,-25,-26","w":293},"'":{"d":"32,-252r28,0r-11,69r-17,0r0,-69","w":78,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"v":-11,"y":-11,"\u00fd":-11,"\u00ff":-11,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"(":{"d":"100,-244v-64,69,-65,241,0,310r-18,13v-79,-68,-77,-269,1,-335","w":100,"k":{"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"V":-4,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2}},")":{"d":"1,67v64,-69,64,-241,0,-310r18,-13v79,68,77,269,-1,335","w":100},"*":{"d":"47,-257v7,10,12,22,15,35v5,-12,9,-25,16,-35r18,9v-7,13,-16,23,-26,33v13,-2,26,-5,42,-4r0,20v-15,1,-28,-2,-40,-4v9,9,19,18,25,31r-17,10v-7,-11,-13,-24,-18,-37v-4,13,-9,26,-16,36r-18,-10v7,-12,15,-21,25,-30v-12,2,-24,5,-39,4r0,-20v16,-1,28,2,41,4v-10,-9,-19,-19,-26,-32","w":126,"k":{" ":22,"\u00a0":22,"-":57,"\u00ad":57,"\u2013":57,"\u2014":57,",":90,".":90,"\u2026":90,"V":-4,"W":-4,"c":5,"e":5,"g":5,"o":5,"q":5,"\u00e7":5,"\u00e8":5,"\u00e9":5,"\u00ea":5,"\u00eb":5,"\u00f0":5,"\u00f2":5,"\u00f3":5,"\u00f4":5,"\u00f5":5,"\u00f6":5,"\u00f8":5,"v":-5,"y":-5,"\u00fd":-5,"\u00ff":-5,"\u00c6":21,"A":4,"\u00c0":4,"\u00c1":4,"\u00c2":4,"\u00c3":4,"\u00c4":4,"\u00c5":4}},"+":{"d":"14,-135r64,0r0,-64r26,0r0,64r63,0r0,26r-63,0r0,65r-26,0r0,-65r-64,0r0,-26","w":181},",":{"d":"41,3v-13,4,-23,-4,-23,-18v0,-12,8,-21,20,-20v41,3,24,72,0,82v-5,2,-9,6,-14,7r-9,-14v15,-5,24,-21,26,-37","w":70,"k":{" ":11,"\u00a0":11,"*":51,"-":45,"\u00ad":45,"\u2013":45,"\u2014":45,",":-23,".":-23,"\u2026":-23,"T":11,"V":21,"W":10,"Y":5,"\u00dd":5,"v":9,"y":9,"\u00fd":9,"\u00ff":9,"w":8,"x":-7,"\u00c6":-14,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":6,"\u2122":6}},"-":{"d":"21,-117r87,0r0,27r-87,0r0,-27","w":129,"k":{" ":29,"\u00a0":29,"*":40,",":45,".":45,"\u2026":45,"T":30,"V":10,"X":29,"Y":5,"\u00dd":5,"Z":4,"\u00c6":16,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":13,"]":13,"}":13}},".":{"d":"38,4v-12,1,-20,-9,-20,-21v0,-12,8,-20,20,-20v12,0,22,8,21,20v1,13,-8,22,-21,21","w":77,"k":{" ":11,"\u00a0":11,"*":51,"-":45,"\u00ad":45,"\u2013":45,"\u2014":45,",":-23,".":-23,"\u2026":-23,"T":11,"V":21,"W":10,"Y":5,"\u00dd":5,"v":9,"y":9,"\u00fd":9,"\u00ff":9,"w":8,"x":-7,"\u00c6":-14,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":6,"\u2122":6}},"\/":{"d":"118,-256r23,10r-132,296r-22,-10","w":127},"0":{"d":"105,4v-66,0,-82,-58,-82,-130v0,-73,18,-130,82,-130v67,0,82,53,83,130v0,74,-19,130,-83,130xm105,-231v-46,0,-53,47,-52,105v1,51,6,105,52,105v46,0,53,-47,53,-105v0,-50,-4,-105,-53,-105"},"1":{"d":"46,-27r50,0v2,-64,-5,-138,4,-195v-13,20,-35,31,-54,45r-14,-18r80,-61r13,0r0,229r49,0r0,27r-128,0r0,-27"},"2":{"d":"36,-233v37,-36,137,-32,132,38v-5,69,-46,112,-79,155v-5,7,-13,10,-18,17v29,-7,68,-3,102,-4r0,27r-143,0r0,-10v42,-49,99,-99,108,-180v5,-50,-67,-48,-90,-23"},"3":{"d":"46,-30v40,18,102,9,102,-43v0,-44,-35,-53,-82,-50r0,-10v23,-32,39,-71,68,-96v-26,7,-63,3,-95,4r0,-27r129,0r0,10v-23,33,-42,70,-70,98v45,-10,79,21,79,67v0,71,-75,96,-138,72"},"4":{"d":"196,-77r-43,0r0,77r-28,0r0,-77r-111,0r0,-12r120,-167r19,0r0,153r43,0r0,26xm125,-103v-1,-36,0,-79,3,-108v-22,42,-50,78,-81,111v23,-4,51,-3,78,-3"},"5":{"d":"42,-27v43,17,99,2,99,-50v0,-47,-43,-57,-90,-50r0,-125r112,0r0,27r-85,0r0,71v57,-4,92,22,92,75v0,70,-69,98,-135,76"},"6":{"d":"112,-150v45,0,73,29,72,74v-1,49,-27,78,-76,80v-105,5,-88,-151,-45,-207v20,-26,49,-48,87,-53r6,23v-56,10,-87,53,-97,109v8,-14,29,-27,53,-26xm108,-21v30,0,42,-22,46,-52v8,-63,-82,-64,-96,-23v-4,41,11,75,50,75"},"7":{"d":"47,0r90,-211r16,-18v-35,8,-83,2,-124,4r0,-27r151,0r0,10r-104,242r-29,0","k":{" ":19,"\u00a0":19,"-":23,"\u00ad":23,"\u2013":23,"\u2014":23,",":40,".":40,"\u2026":40,"C":5,"G":5,"O":5,"Q":5,"\u00c7":5,"\u00d2":5,"\u00d3":5,"\u00d4":5,"\u00d5":5,"\u00d6":5,"\u00d8":5,"c":27,"e":27,"g":27,"o":27,"q":27,"\u00e7":27,"\u00e8":27,"\u00e9":27,"\u00ea":27,"\u00eb":27,"\u00f0":27,"\u00f2":27,"\u00f3":27,"\u00f4":27,"\u00f5":27,"\u00f6":27,"\u00f8":27,"t":9,"\u00c6":21,"A":21,"\u00c0":21,"\u00c1":21,"\u00c2":21,"\u00c3":21,"\u00c4":21,"\u00c5":21,"a":16,"m":16,"n":16,"p":16,"r":16,"s":16,"u":16,"\u00e6":16,"\u00e0":9,"\u00e1":9,"\u00e2":9,"\u00e3":9,"\u00e4":9,"\u00e5":9,"\u00ec":9,"\u00ed":9,"\u00ee":9,"\u00ef":9,"\u00f1":9,"\u00f9":9,"\u00fa":9,"\u00fb":9,"\u00fc":9}},"8":{"d":"103,4v-43,0,-71,-21,-71,-64v0,-37,20,-54,49,-70v-23,-13,-44,-29,-44,-63v0,-41,27,-63,70,-63v40,0,66,20,66,57v0,35,-16,49,-40,67v23,14,46,30,46,66v0,46,-29,70,-76,70xm105,-21v42,0,61,-52,30,-76v-10,-8,-23,-17,-35,-23v-46,13,-59,99,5,99xm107,-231v-40,0,-53,46,-27,69v9,8,22,15,33,21v18,-14,30,-26,32,-52v1,-23,-17,-38,-38,-38"},"9":{"d":"151,-123v-38,43,-131,15,-125,-53v4,-50,27,-78,78,-80v102,-5,89,159,43,213v-21,24,-49,42,-86,47r-7,-23v57,-9,87,-48,97,-104xm102,-231v-30,0,-46,20,-46,52v0,58,74,66,97,31v4,-44,-8,-83,-51,-83"},":":{"d":"53,-141v-12,0,-20,-9,-20,-21v0,-12,8,-21,20,-21v12,0,22,9,22,21v0,12,-10,21,-22,21xm53,4v-12,0,-20,-9,-20,-21v0,-12,8,-20,20,-20v13,0,22,8,22,20v0,12,-9,21,-22,21","w":88,"k":{"\/":-7}},";":{"d":"55,3v-13,4,-23,-5,-23,-18v0,-12,9,-21,21,-20v41,3,24,74,-1,82v-5,3,-8,6,-13,7r-9,-14v15,-5,24,-20,25,-37xm55,-141v-12,0,-20,-9,-20,-21v0,-12,8,-21,20,-21v12,0,21,8,21,21v0,13,-9,21,-21,21","w":92},"<":{"d":"15,-110r0,-10r136,-83r14,22v-39,22,-73,49,-118,66v47,14,80,42,120,63r-14,22","w":181},"=":{"d":"14,-105r153,0r0,26r-153,0r0,-26xm14,-165r153,0r0,26r-153,0r0,-26","w":181},">":{"d":"167,-124r0,11r-136,83r-14,-22v39,-22,73,-49,118,-66v-46,-15,-80,-42,-120,-63r14,-22","w":181},"?":{"d":"144,-198v0,67,-64,70,-66,134r-24,0v-5,-67,55,-73,60,-130v4,-47,-67,-42,-91,-22r-10,-22v40,-29,131,-27,131,40xm67,4v-12,0,-20,-9,-20,-21v0,-12,8,-20,20,-20v13,0,22,8,22,20v0,12,-9,21,-22,21","w":156},"@":{"d":"206,-179v18,-1,25,6,36,13v7,-5,11,-13,25,-11r-22,133v0,11,2,19,13,18v44,-5,67,-41,67,-91v0,-77,-51,-115,-127,-115v-86,0,-137,58,-140,145v-3,103,90,158,186,124r8,23v-110,39,-227,-25,-221,-145v5,-105,65,-171,169,-171v92,0,152,48,152,139v0,64,-38,110,-99,116v-28,2,-35,-20,-33,-46v-14,22,-34,46,-66,46v-29,0,-42,-24,-42,-55v0,-64,32,-119,94,-123xm140,-60v0,58,59,26,71,-2v16,-19,17,-51,23,-79v-7,-9,-14,-13,-28,-13v-45,0,-66,47,-66,94","w":383},"A":{"d":"150,-70r-92,0r-26,70r-29,0r95,-256r14,0r96,256r-32,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115"},"B":{"d":"31,-250v65,-6,153,-16,152,56v0,33,-22,50,-48,60v31,6,54,25,55,62v0,75,-87,83,-159,70r0,-248xm158,-69v-1,-48,-49,-48,-98,-47r0,90v42,7,99,4,98,-43xm151,-188v0,-44,-49,-43,-91,-39r0,86v47,3,91,-5,91,-47","k":{"T":11}},"C":{"d":"52,-126v-8,81,66,126,133,92r7,24v-14,12,-39,14,-63,14v-76,0,-106,-53,-109,-130v-3,-99,72,-151,168,-122r-7,27v-68,-28,-138,14,-129,95","w":205,"k":{" ":14,"\u00a0":14,"-":28,"\u00ad":28,"\u2013":28,"\u2014":28,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":10,"V":10,"W":2,"X":15,"Y":13,"\u00dd":13,"Z":9,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":15,"y":15,"\u00fd":15,"\u00ff":15,"w":14,"x":10,"z":8,"\u00c6":41,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"a":6,"m":6,"n":6,"p":6,"r":6,"s":6,"u":6,"\u00e6":6}},"D":{"d":"215,-128v3,105,-72,145,-184,128r0,-252v20,-4,43,-3,67,-3v79,0,115,48,117,127xm184,-128v0,-72,-44,-112,-124,-98r0,201v81,13,124,-28,124,-103","w":235,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"E":{"d":"31,-252r137,0r0,27r-108,0r0,82r99,0r0,27r-99,0r0,89r110,0r0,27r-139,0r0,-252","w":192},"F":{"d":"31,-252r137,0r0,27r-108,0r0,86r101,0r0,26r-101,0r0,113r-29,0r0,-252","w":186},"G":{"d":"52,-126v0,77,54,123,123,95r0,-71r-59,-7r0,-17r84,0r0,111v-17,12,-41,19,-69,19v-78,-1,-109,-51,-111,-130v-3,-100,76,-151,173,-122r-8,27v-68,-27,-133,13,-133,95","w":220},"H":{"d":"181,-116r-121,0r0,116r-29,0r0,-252r29,0r0,110r121,0r0,-110r30,0r0,252r-30,0r0,-116","w":241},"I":{"d":"37,-252r30,0r0,252r-30,0r0,-252","w":104},"J":{"d":"-6,-28v26,14,46,-2,46,-35r0,-189r30,0r0,197v4,49,-38,70,-82,53","w":104},"K":{"d":"77,-117r-17,0r0,117r-29,0r0,-252r29,0r0,117r17,-5r84,-112r35,0r-84,108r-16,12r19,15r92,117r-38,0","w":219,"k":{" ":11,"\u00a0":11,"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,"C":18,"G":18,"O":18,"Q":18,"\u00c7":18,"\u00d2":18,"\u00d3":18,"\u00d4":18,"\u00d5":18,"\u00d6":18,"\u00d8":18,"T":12,"X":11,"Y":10,"\u00dd":10,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":14,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":19,"x":14,"z":12,"\u00c6":36,"A":11,"\u00c0":11,"\u00c1":11,"\u00c2":11,"\u00c3":11,"\u00c4":11,"\u00c5":11,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10}},"L":{"d":"180,0r-149,0r0,-252r29,0r0,225r120,0r0,27","w":186,"k":{" ":15,"\u00a0":15,"*":58,"-":28,"\u00ad":28,"\u2013":28,"\u2014":28,"C":24,"G":24,"O":24,"Q":24,"\u00c7":24,"\u00d2":24,"\u00d3":24,"\u00d4":24,"\u00d5":24,"\u00d6":24,"\u00d8":24,"T":44,"V":37,"W":26,"X":37,"Y":38,"\u00dd":38,"Z":11,"c":21,"e":21,"g":21,"o":21,"q":21,"\u00e7":21,"\u00e8":21,"\u00e9":21,"\u00ea":21,"\u00eb":21,"\u00f0":21,"\u00f2":21,"\u00f3":21,"\u00f4":21,"\u00f5":21,"\u00f6":21,"\u00f8":21,"t":17,"v":35,"y":35,"\u00fd":35,"\u00ff":35,"w":25,"x":15,"z":12,"\u00c6":28,"\"":45,"'":45,"\u2018":45,"\u2019":45,"\u201c":45,"\u201d":45,"\u00ae":53,"\u2122":53,"A":27,"\u00c0":27,"\u00c1":27,"\u00c2":27,"\u00c3":27,"\u00c4":27,"\u00c5":27,"a":7,"m":7,"n":7,"p":7,"r":7,"s":7,"u":7,"\u00e6":7}},"M":{"d":"226,-207v-20,55,-53,99,-79,148r-9,0v-29,-49,-62,-93,-84,-148v10,61,3,138,5,207r-28,0r0,-252r22,0v30,53,66,99,91,157v23,-58,58,-104,87,-157r23,0r0,252r-30,0","w":284},"N":{"d":"196,4v-46,-69,-100,-130,-139,-205r-2,0v8,60,2,134,4,201r-28,0r0,-256r15,0v46,68,100,129,140,203r2,0v-8,-60,-2,-133,-4,-199r28,0r0,256r-16,0","w":242},"O":{"d":"123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"P":{"d":"188,-177v0,68,-60,90,-128,81r0,96r-29,0r0,-249v69,-15,157,-7,157,72xm156,-177v0,-49,-49,-56,-96,-50r0,105v51,4,96,-3,96,-55","w":201,"k":{" ":14,"\u00a0":14,",":47,".":47,"\u2026":47,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"T":6,"X":15,"Y":9,"\u00dd":9,"Z":10,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"x":13,"z":10,"\u00c6":40,"A":23,"\u00c0":23,"\u00c1":23,"\u00c2":23,"\u00c3":23,"\u00c4":23,"\u00c5":23,"a":13,"m":13,"n":13,"p":13,"r":13,"s":13,"u":13,"\u00e6":13,"\u00e0":13,"\u00e1":13,"\u00e2":13,"\u00e3":13,"\u00e4":13,"\u00e5":13,"\u00ec":13,"\u00ed":13,"\u00ee":13,"\u00ef":13,"\u00f1":13,"\u00f9":13,"\u00fa":13,"\u00fb":13,"\u00fc":13}},"Q":{"d":"76,18v63,-13,108,34,177,18r0,26v-65,18,-113,-26,-177,-18r0,-26xm123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"R":{"d":"177,-185v0,40,-26,63,-57,72r18,13r62,100r-35,0r-69,-109r-36,-5r0,114r-29,0r0,-249v65,-12,146,-10,146,64xm146,-184v0,-40,-44,-51,-86,-43r0,93v47,3,86,-5,86,-50","w":214,"k":{"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"C":16,"G":16,"O":16,"Q":16,"\u00c7":16,"\u00d2":16,"\u00d3":16,"\u00d4":16,"\u00d5":16,"\u00d6":16,"\u00d8":16,"T":22,"V":17,"W":14,"X":14,"Y":22,"\u00dd":22,"Z":9,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":9,"v":12,"y":12,"\u00fd":12,"\u00ff":12,"w":10,"x":14,"z":10,"\u00c6":38,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"a":4,"m":4,"n":4,"p":4,"r":4,"s":4,"u":4,"\u00e6":4,"\u00e0":4,"\u00e1":4,"\u00e2":4,"\u00e3":4,"\u00e4":4,"\u00e5":4,"\u00ec":4,"\u00ed":4,"\u00ee":4,"\u00ef":4,"\u00f1":4,"\u00f9":4,"\u00fa":4,"\u00fb":4,"\u00fc":4}},"S":{"d":"27,-36v32,18,123,26,117,-28v-8,-71,-121,-44,-121,-128v0,-69,91,-75,147,-53r-9,26v-31,-13,-114,-22,-108,25v9,67,121,46,121,127v0,77,-99,83,-157,58","w":191},"T":{"d":"193,-225r-78,0r0,225r-30,0r0,-225r-79,0r0,-27r187,0r0,27","w":199,"k":{"\u00ff":46,"\u00fd":46,"\u00f6":46,"\u00f5":46,"\u00f4":46,"\u00f3":46,"\u00f2":46,"\u00ef":28,"\u00ee":28,"\u00eb":46,"\u00ea":46,"\u00e9":46,"\u00e8":46," ":14,"\u00a0":14,"-":30,"\u00ad":30,"\u2013":30,"\u2014":30,",":37,".":37,"\u2026":37,"C":17,"G":17,"O":17,"Q":17,"\u00c7":17,"\u00d2":17,"\u00d3":17,"\u00d4":17,"\u00d5":17,"\u00d6":17,"\u00d8":17,"T":-7,"X":12,"Y":4,"\u00dd":4,"Z":9,"c":46,"e":46,"g":46,"o":46,"q":46,"\u00e7":46,"\u00f0":46,"\u00f8":46,"t":22,"v":46,"y":46,"w":46,"x":46,"z":46,"\u00c6":42,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":38,"m":38,"n":38,"p":38,"r":38,"s":38,"u":38,"\u00e6":38,"\u00e0":28,"\u00e1":28,"\u00e2":28,"\u00e3":28,"\u00e4":28,"\u00e5":28,"\u00ec":28,"\u00ed":28,"\u00f1":28,"\u00f9":28,"\u00fa":28,"\u00fb":28,"\u00fc":28,")":-10,"]":-10,"}":-10}},"U":{"d":"121,-23v43,0,54,-24,54,-69r0,-160r29,0v-7,105,35,259,-83,255v-58,-2,-90,-24,-90,-81r0,-174r29,0r0,160v0,45,18,69,61,69","w":234},"V":{"d":"32,-252v24,71,55,134,73,211v17,-77,47,-140,70,-211r30,0r-95,256r-14,0r-97,-256r33,0","w":204,"k":{"\u00f6":21,"\u00f5":21,"\u00ef":17,"\u00ee":17,"\u00ec":17,"\u00eb":21," ":11,"\u00a0":11,"*":-17,"-":19,"\u00ad":19,"\u2013":19,"\u2014":19,",":34,".":34,"\u2026":34,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"c":21,"e":21,"g":21,"o":21,"q":21,"\u00e7":21,"\u00e8":21,"\u00e9":21,"\u00ea":21,"\u00f0":21,"\u00f2":21,"\u00f3":21,"\u00f4":21,"\u00f8":21,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":6,"x":17,"z":14,"\u00c6":35,"\"":-14,"'":-14,"\u2018":-14,"\u2019":-14,"\u201c":-14,"\u201d":-14,"\u00ae":-4,"\u2122":-4,"A":16,"\u00c0":16,"\u00c1":16,"\u00c2":16,"\u00c3":16,"\u00c4":16,"\u00c5":16,"a":18,"m":18,"n":18,"p":18,"r":18,"s":18,"u":18,"\u00e6":18,"\u00e0":17,"\u00e1":17,"\u00e2":17,"\u00e3":17,"\u00e4":17,"\u00e5":17,"\u00ed":17,"\u00f1":17,"\u00f9":17,"\u00fa":17,"\u00fb":17,"\u00fc":17,")":-4,"]":-4,"}":-4}},"W":{"d":"35,-252v17,71,41,134,51,211v10,-80,39,-140,58,-211r14,0v19,71,49,131,59,211v11,-75,33,-140,49,-211r29,0r-70,256r-17,0v-19,-69,-45,-131,-57,-207r-2,0v-12,77,-39,137,-58,207r-16,0r-72,-256r32,0","w":298,"k":{"\u00ef":11,"\u00ec":11," ":9,"\u00a0":9,"*":-17,"-":9,"\u00ad":9,"\u2013":9,"\u2014":9,",":27,".":27,"\u2026":27,"C":7,"G":7,"O":7,"Q":7,"\u00c7":7,"\u00d2":7,"\u00d3":7,"\u00d4":7,"\u00d5":7,"\u00d6":7,"\u00d8":7,"c":15,"e":15,"g":15,"o":15,"q":15,"\u00e7":15,"\u00e8":15,"\u00e9":15,"\u00ea":15,"\u00eb":15,"\u00f0":15,"\u00f2":15,"\u00f3":15,"\u00f4":15,"\u00f5":15,"\u00f6":15,"\u00f8":15,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":6,"x":14,"z":13,"\u00c6":30,"\"":-14,"'":-14,"\u2018":-14,"\u2019":-14,"\u201c":-14,"\u201d":-14,"\u00ae":-4,"\u2122":-4,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"a":15,"m":15,"n":15,"p":15,"r":15,"s":15,"u":15,"\u00e6":15,"\u00e0":11,"\u00e1":11,"\u00e2":11,"\u00e3":11,"\u00e4":11,"\u00e5":11,"\u00ed":11,"\u00ee":11,"\u00f1":11,"\u00f9":11,"\u00fa":11,"\u00fb":11,"\u00fc":11}},"X":{"d":"93,-128r-76,-124r36,0v20,35,44,67,60,106v15,-41,42,-70,62,-106r33,0r-79,121r83,131r-35,0v-22,-38,-49,-69,-66,-112v-18,42,-46,74,-68,112r-34,0","w":222,"k":{" ":11,"\u00a0":11,"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,"C":18,"G":18,"O":18,"Q":18,"\u00c7":18,"\u00d2":18,"\u00d3":18,"\u00d4":18,"\u00d5":18,"\u00d6":18,"\u00d8":18,"T":12,"X":11,"Y":10,"\u00dd":10,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":14,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":19,"x":14,"z":12,"\u00c6":36,"A":11,"\u00c0":11,"\u00c1":11,"\u00c2":11,"\u00c3":11,"\u00c4":11,"\u00c5":11,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10}},"Y":{"d":"86,-100r-83,-152r35,0v21,45,50,81,65,132v15,-50,43,-87,63,-132r32,0r-82,152r0,100r-30,0r0,-100","w":200,"k":{"\u00f6":31,"\u00f5":31,"\u00ef":22,"\u00ee":22,"\u00ec":22,"\u00eb":31,"\u00e8":31,"\u00e1":22," ":9,"\u00a0":9,"*":-9,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,",":39,".":39,"\u2026":39,"C":15,"G":15,"O":15,"Q":15,"\u00c7":15,"\u00d2":15,"\u00d3":15,"\u00d4":15,"\u00d5":15,"\u00d6":15,"\u00d8":15,"T":4,"X":10,"Z":9,"c":31,"e":31,"g":31,"o":31,"q":31,"\u00e7":31,"\u00e9":31,"\u00ea":31,"\u00f0":31,"\u00f2":31,"\u00f3":31,"\u00f4":31,"\u00f8":31,"t":14,"v":17,"y":17,"\u00fd":17,"\u00ff":17,"w":14,"x":22,"z":23,"\u00c6":35,"\"":-13,"'":-13,"\u2018":-13,"\u2019":-13,"\u201c":-13,"\u201d":-13,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26,"\u00e0":22,"\u00e2":22,"\u00e3":22,"\u00e4":22,"\u00e5":22,"\u00ed":22,"\u00f1":22,"\u00f9":22,"\u00fa":22,"\u00fb":22,"\u00fc":22}},"Z":{"d":"14,-27r127,-184r15,-14r-142,0r0,-27r169,0r0,27r-128,185r-15,13r143,0r0,27r-169,0r0,-27","w":196,"k":{" ":15,"\u00a0":15,"-":33,"\u00ad":33,"\u2013":33,"\u2014":33,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":9,"X":10,"Y":9,"\u00dd":9,"Z":8,"c":18,"e":18,"g":18,"o":18,"q":18,"\u00e7":18,"\u00e8":18,"\u00e9":18,"\u00ea":18,"\u00eb":18,"\u00f0":18,"\u00f2":18,"\u00f3":18,"\u00f4":18,"\u00f5":18,"\u00f6":18,"\u00f8":18,"t":6,"v":11,"y":11,"\u00fd":11,"\u00ff":11,"w":11,"x":8,"z":10,"\u00c6":36,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7,"a":8,"m":8,"n":8,"p":8,"r":8,"s":8,"u":8,"\u00e6":8}},"[":{"d":"31,-252r65,0r0,25r-37,0r0,285r37,0r0,25r-65,0r0,-335","w":109,"k":{"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"V":-4,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2}},"\\":{"d":"144,40r-24,10r-133,-296r24,-10","w":136},"]":{"d":"79,83r-65,0r0,-25r37,0r0,-285r-37,0r0,-25r65,0r0,335","w":109},"^":{"d":"84,-256r11,0r61,99r-30,0v-13,-23,-30,-43,-37,-73v-10,29,-28,50,-44,73r-28,0","w":180},"_":{"d":"0,49r147,0r0,25r-147,0r0,-25","w":146},"`":{"d":"79,-206r-16,0r-41,-46r0,-7r34,0","w":100},"a":{"d":"124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30","w":178,"k":{"\u201d":3,"\u201c":3,"\u2019":3,"\u2018":3,"T":43,"'":3,"\"":3}},"b":{"d":"177,-93v0,88,-84,115,-149,83r0,-242r29,0r1,90v10,-13,27,-23,49,-22v51,1,70,35,70,91xm147,-93v-3,-35,-10,-65,-45,-66v-26,0,-39,17,-45,38r0,91v46,23,95,-5,90,-63","w":194,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"c":{"d":"48,-90v-10,60,54,86,93,56r9,22v-13,10,-34,16,-56,16v-57,1,-73,-38,-76,-94v-4,-77,61,-114,129,-84r-8,25v-44,-22,-97,-8,-91,59","w":162,"k":{"y":4," ":9,"\u00a0":9,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"c":8,"e":8,"g":8,"o":8,"q":8,"\u00e7":8,"\u00e8":8,"\u00e9":8,"\u00ea":8,"\u00eb":8,"\u00f0":8,"\u00f2":8,"\u00f3":8,"\u00f4":8,"\u00f5":8,"\u00f6":8,"\u00f8":8,"x":6,"z":6,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5}},"d":{"d":"18,-89v0,-73,54,-110,119,-88r0,-75r29,0r0,223v0,10,2,20,4,30r-20,0v-4,-8,-2,-21,-9,-26v-9,15,-27,30,-52,29v-53,-1,-71,-34,-71,-93xm48,-89v0,38,9,67,45,68v59,3,42,-74,44,-128v-42,-24,-89,0,-89,60","w":193},"e":{"d":"48,-87v-10,62,61,82,100,52r11,21v-13,12,-38,17,-62,18v-57,0,-79,-37,-79,-94v0,-58,26,-92,79,-94v56,-2,75,40,66,97r-115,0xm137,-110v7,-50,-45,-60,-74,-38v-9,7,-13,20,-15,38r89,0","w":182,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":4,"'":4,"\u2018":4,"\u2019":4,"\u201c":4,"\u201d":4}},"f":{"d":"120,-223v-20,-10,-57,-11,-55,19r0,24r48,0r0,25r-48,0r0,155r-29,0r0,-155r-28,0r0,-25r28,0v-10,-61,36,-90,90,-67","w":114,"k":{"\u00ef":-22,"\u00ee":-9,"\u00ec":-17,"}":-22,"]":-22,"*":-6,",":9,".":9,"\u2026":9,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"t":6,"\"":-6,"'":-6,"\u2018":-6,"\u2019":-6,"\u201c":-6,"\u201d":-6,"\u00ae":-6,"\u2122":-6,")":-22}},"g":{"d":"18,-89v-6,-86,80,-111,148,-83r0,180v7,69,-75,80,-131,59r7,-25v37,16,105,15,95,-42v-1,-6,2,-14,-1,-18v-11,13,-23,22,-48,22v-53,-2,-66,-35,-70,-93xm48,-90v0,38,9,68,45,69v59,3,41,-75,44,-130v-46,-20,-89,3,-89,61","w":193},"h":{"d":"113,-184v86,0,53,108,59,184r-29,0v-8,-59,25,-158,-38,-159v-24,0,-48,17,-48,39r0,120r-29,0r0,-252r29,0r1,92v12,-15,28,-24,55,-24","w":196},"i":{"d":"34,-180r29,0r0,180r-29,0r0,-180xm48,-216v-12,0,-20,-7,-20,-19v0,-12,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,19,-20,19","w":96},"j":{"d":"3,51v29,1,30,-23,30,-52r0,-179r29,0r0,190v1,45,-13,69,-59,66r0,-25xm47,-216v-11,0,-20,-8,-20,-19v0,-11,9,-20,20,-20v11,0,21,9,21,20v0,11,-9,19,-21,19","w":96},"k":{"d":"73,-81r-16,0r0,81r-29,0r0,-252r29,0r0,153r14,-5r56,-76r34,0v-24,28,-42,61,-70,84v33,25,52,64,78,96r-36,0","w":172,"k":{"\u00f8":9,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00f0":9,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":9,"q":9,"o":9,"g":9,"e":9,"c":9," ":11,"\u00a0":11,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":6}},"l":{"d":"102,-2v-29,12,-71,9,-71,-34r0,-216r29,0r0,208v-3,25,19,27,39,19","w":105},"m":{"d":"55,-158v16,-30,93,-40,101,4v10,-17,30,-29,56,-30v83,-4,47,110,55,184r-28,0r0,-108v-1,-30,-4,-52,-35,-51v-65,1,-36,99,-42,159r-29,0r0,-102v0,-32,-2,-57,-34,-57v-23,0,-36,17,-42,35r0,124r-29,0r0,-180r20,0v3,7,1,18,7,22","w":292},"n":{"d":"113,-184v85,0,53,108,59,184r-29,0v-7,-58,24,-157,-38,-159v-26,-1,-42,17,-48,36r0,123r-29,0r0,-180r20,0v3,7,1,18,7,22v11,-15,31,-26,58,-26","w":196,"k":{"T":46}},"o":{"d":"96,4v-56,0,-78,-37,-78,-94v0,-57,25,-94,78,-94v57,0,79,37,79,94v0,57,-26,94,-79,94xm145,-90v0,-39,-11,-68,-49,-69v-33,0,-48,23,-48,69v0,38,12,69,48,69v33,0,49,-23,49,-69","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"p":{"d":"177,-94v2,71,-54,116,-120,91r0,75r-29,0r0,-252r20,0v2,7,2,17,6,22v10,-16,27,-26,52,-26v53,1,69,32,71,90xm147,-94v0,-38,-11,-64,-47,-65v-58,-3,-40,74,-43,128v43,27,90,-3,90,-63","w":194,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"q":{"d":"18,-89v0,-87,81,-111,148,-83r0,244r-29,0v-2,-29,4,-65,-2,-90v-10,14,-22,23,-47,22v-52,-2,-70,-35,-70,-93xm48,-90v0,38,9,68,45,69v59,3,41,-75,44,-130v-45,-20,-89,2,-89,61","w":193},"r":{"d":"53,-158v14,-19,34,-34,66,-22r-6,28v-26,-11,-56,1,-56,26r0,126r-29,0r0,-180r20,0","w":122,"k":{",":22,".":22,"\u2026":22,"t":-11}},"s":{"d":"23,-33v22,12,89,25,84,-16v-6,-47,-87,-26,-87,-85v0,-57,72,-59,111,-39r-6,24v-20,-10,-82,-22,-76,14v8,45,87,22,87,85v0,60,-80,64,-122,41","w":151},"t":{"d":"118,-6v-36,18,-86,16,-86,-44r0,-105r-28,0r0,-25r28,0r0,-36r29,-8r0,44r49,0r0,25r-49,0r0,100v-5,37,28,39,51,27","w":122,"k":{"-":12,"\u00ad":12,"\u2013":12,"\u2014":12,",":-6,".":-6,"\u2026":-6,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"x":6}},"u":{"d":"84,4v-85,0,-53,-108,-59,-184r29,0r0,103v-1,32,4,57,35,56v28,0,40,-19,49,-39r0,-120r28,0v1,60,-4,127,4,180r-20,0v-4,-9,-2,-22,-9,-28v-12,18,-28,32,-57,32","w":194},"v":{"d":"36,-180v18,46,41,88,54,140v12,-51,32,-94,49,-140r31,0r-76,184r-13,0r-78,-184r33,0","w":173,"k":{" ":13,"\u00a0":13,"*":-5,",":26,".":26,"\u2026":26,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"w":{"d":"144,-180v17,46,39,88,51,140v9,-51,26,-94,39,-140r28,0r-61,184r-14,0v-18,-50,-42,-93,-54,-148v-14,52,-35,99,-53,148r-14,0r-63,-184r31,0v14,46,35,87,42,140v11,-51,31,-94,47,-140r21,0","w":264,"k":{" ":9,"\u00a0":9,",":22,".":22,"\u2026":22,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":-2,"y":-2,"\u00fd":-2,"\u00ff":-2,"x":5,"z":6}},"x":{"d":"75,-92r-61,-88r36,0v15,23,32,44,44,70v12,-27,30,-47,45,-70r33,0r-61,86r64,94r-34,0v-17,-25,-36,-48,-49,-76v-14,28,-33,51,-50,76r-32,0","w":185,"k":{" ":11,"\u00a0":11,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"c":9,"e":9,"g":9,"o":9,"q":9,"\u00e7":9,"\u00e8":9,"\u00e9":9,"\u00ea":9,"\u00eb":9,"\u00f0":9,"\u00f2":9,"\u00f3":9,"\u00f4":9,"\u00f5":9,"\u00f6":9,"\u00f8":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":6}},"y":{"d":"93,-29v10,-55,28,-101,42,-151r30,0r-66,196v-11,31,-29,70,-71,54r5,-25v28,7,37,-18,44,-45r-73,-180r33,0","w":167,"k":{" ":13,"\u00a0":13,"*":-5,",":26,".":26,"\u2026":26,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"z":{"d":"15,-25v33,-43,61,-91,98,-130r-98,0r0,-25r128,0r0,25v-33,43,-61,91,-98,130r98,0r0,25r-128,0r0,-25","w":160,"k":{" ":11,"\u00a0":11,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"v":4,"y":4,"\u00fd":4,"\u00ff":4}},"{":{"d":"114,83v-37,2,-65,-1,-65,-38v0,-43,19,-117,-28,-117r0,-25v77,-2,-37,-176,93,-155r0,25v-21,-1,-37,-1,-37,21v0,46,12,111,-25,122v39,7,25,76,25,120v0,22,15,23,37,22r0,25","w":124,"k":{"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"V":-4,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2}},"|":{"d":"31,-252r24,0r0,299r-24,0r0,-299","w":85},"}":{"d":"20,-252v36,-2,67,0,65,37v6,42,-20,118,28,117r0,26v-76,2,36,175,-93,155r0,-25v21,1,37,1,37,-22v0,-46,-12,-110,24,-121v-38,-8,-24,-77,-24,-121v0,-21,-16,-22,-37,-21r0,-25","w":124},"~":{"d":"126,-105v-36,-7,-75,-36,-103,-3r-12,-22v16,-13,29,-21,51,-21v36,0,67,38,96,7r13,22v-15,9,-27,16,-45,17","w":181},"\u00a0":{"w":96,"k":{"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,",":31,".":31,"\u2026":31,"T":11,"V":11,"W":7,"X":11,"Y":11,"\u00dd":11,"Z":8,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"z":11,"\u00c6":14,"\"":24,"'":24,"\u2018":24,"\u2019":24,"\u201c":24,"\u201d":24,"A":12,"\u00c0":12,"\u00c1":12,"\u00c2":12,"\u00c3":12,"\u00c4":12,"\u00c5":12}},"\u00a1":{"d":"63,72r-30,0v0,-65,-2,-132,7,-188r17,0v8,57,6,123,6,188xm47,-142v-12,0,-20,-9,-20,-21v0,-12,8,-21,20,-21v12,0,21,8,21,21v0,13,-9,21,-21,21","w":109},"\u00a2":{"d":"127,-21v16,1,28,-7,37,-13r9,22v-11,8,-26,14,-43,15r0,33r-26,0r0,-32v-47,-6,-66,-40,-65,-94v0,-52,21,-87,65,-93r0,-33r26,0r0,32v17,0,29,5,40,10r-8,25v-9,-4,-22,-10,-35,-10r0,138xm108,-158v-46,1,-53,100,-19,127v5,4,12,7,19,9r0,-136"},"\u00a3":{"d":"22,-26v46,2,51,-54,35,-87r-35,0r0,-25r24,0v-25,-52,-2,-118,65,-118v26,0,48,4,65,11r-9,26v-33,-17,-101,-19,-101,33v0,20,5,35,12,48r58,0r0,25r-47,0v14,32,3,79,-21,91v31,-9,76,-4,115,-5r0,27r-161,0r0,-26"},"\u00a4":{"d":"55,-87v-15,-19,-14,-56,0,-74v-17,-9,-27,-24,-40,-36r17,-18v12,13,27,24,36,41v19,-16,54,-16,74,0v9,-17,24,-28,36,-41r18,18v-13,12,-24,27,-40,36v15,19,15,55,0,74v17,8,27,24,40,36r-18,17v-12,-13,-27,-23,-35,-40v-19,14,-56,15,-75,0v-9,16,-24,27,-36,40r-17,-17v13,-12,22,-29,40,-36xm105,-162v-21,0,-37,17,-37,38v0,21,16,38,37,38v21,0,37,-16,37,-38v0,-22,-16,-38,-37,-38"},"\u00a5":{"d":"47,-118r34,0r-73,-134r35,0v21,45,50,81,65,132v15,-50,43,-87,63,-132r32,0r-73,134r35,0r0,22r-44,0r0,22r44,0r0,22r-44,0r0,52r-30,0r0,-52r-44,0r0,-22r44,0r0,-22r-44,0r0,-22"},"\u00a6":{"d":"31,-76r24,0r0,123r-24,0r0,-123xm55,-129r-24,0r0,-123r24,0r0,123","w":85},"\u00a7":{"d":"39,-31v23,16,100,14,70,-26v-37,-19,-109,-29,-83,-92v5,-12,15,-21,30,-24v-40,-19,-21,-83,34,-83v24,0,42,4,57,11r-7,24v-23,-17,-100,-14,-70,26v36,19,109,29,83,92v-5,12,-16,20,-31,23v12,8,23,19,23,39v3,53,-78,53,-113,33xm49,-128v0,37,81,54,81,4v0,-28,-33,-29,-54,-39v-13,6,-27,17,-27,35","w":178},"\u00a8":{"d":"39,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm108,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":147},"\u00a9":{"d":"145,22v-81,0,-127,-46,-127,-126v0,-80,50,-127,127,-127v77,0,127,47,127,127v0,79,-49,126,-127,126xm145,-207v-65,0,-101,38,-101,103v0,66,38,103,101,103v64,0,102,-38,102,-103v0,-64,-37,-103,-102,-103xm113,-104v-3,39,36,54,66,37r8,21v-45,24,-110,2,-102,-58v-5,-58,51,-85,99,-59r-9,22v-28,-16,-67,-5,-62,37","w":290},"\u00aa":{"d":"96,-209v7,-41,-48,-24,-65,-17r-6,-18v27,-13,96,-25,96,25v0,27,-3,58,1,82r-19,0v-3,-5,-1,-14,-7,-16v-14,27,-81,24,-78,-17v2,-36,42,-40,78,-39xm67,-190v-26,-3,-34,34,-4,34v22,0,35,-9,33,-34v-10,-1,-19,-1,-29,0","w":140},"\u00ab":{"d":"80,-93r57,-82r19,15v-17,23,-29,50,-52,66v24,15,37,42,54,64r-19,16xm14,-93r58,-83r19,15v-17,23,-28,51,-52,67v24,15,37,42,54,64r-19,16","w":172},"\u00ac":{"d":"15,-141r152,0r0,69r-26,0r0,-43r-126,0r0,-26","w":181},"\u00ad":{"d":"21,-117r87,0r0,27r-87,0r0,-27","w":129,"k":{" ":29,"\u00a0":29,"*":40,",":45,".":45,"\u2026":45,"T":30,"V":10,"X":29,"Y":5,"\u00dd":5,"Z":4,"\u00c6":16,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":13,"]":13,"}":13}},"\u00ae":{"d":"126,-67v-59,0,-95,-35,-95,-95v0,-61,37,-96,95,-96v58,0,95,35,95,96v0,60,-36,95,-95,95xm126,-237v-47,0,-73,28,-73,75v0,47,28,74,73,74v46,0,73,-26,73,-74v0,-47,-28,-75,-73,-75xm125,-213v39,-7,51,52,11,53v19,8,24,30,37,44r-22,0v-13,-15,-19,-39,-43,-43r0,43r-19,0r0,-93v8,-2,25,-5,36,-4xm108,-170v16,0,34,1,34,-14v0,-12,-21,-16,-34,-11r0,25","w":252},"\u00af":{"d":"22,-231r106,0r0,22r-106,0r0,-22","w":149},"\u00b0":{"d":"81,-155v-32,0,-50,-19,-50,-51v0,-30,19,-50,50,-50v32,0,51,18,51,50v0,32,-19,51,-51,51xm81,-235v-14,1,-28,13,-28,29v0,17,13,30,28,30v15,0,28,-12,28,-30v0,-17,-14,-29,-28,-29","w":153},"\u00b1":{"d":"14,-178r64,0r0,-65r26,0r0,65r63,0r0,26r-63,0r0,44r-26,0r0,-44r-64,0r0,-26xm14,-90r153,0r0,26r-153,0r0,-26","w":181},"\u00b2":{"d":"23,-277v28,-22,97,-20,93,29v-4,46,-36,70,-64,94v18,-7,46,-5,71,-5r0,22r-105,0r0,-12v27,-24,67,-52,72,-96v3,-30,-44,-24,-59,-11","w":142},"\u00b3":{"d":"30,-163v21,11,67,12,67,-20v0,-26,-27,-27,-55,-26v7,-28,30,-41,47,-60v-18,5,-42,3,-64,3r0,-22r92,0r0,12v-15,17,-28,37,-46,51v29,-5,51,13,51,42v0,45,-58,59,-98,42","w":142},"\u00b4":{"d":"43,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":96},"\u00b5":{"d":"148,-27v-11,30,-80,45,-100,13r-2,0v6,25,8,54,7,86r-29,0r0,-252r29,0v7,59,-23,158,40,159v28,0,45,-19,52,-42r0,-117r29,0v2,60,-5,129,6,180r-20,0v-5,-8,-5,-21,-12,-27","w":198},"\u03bc":{"d":"148,-27v-11,30,-80,45,-100,13r-2,0v6,25,8,54,7,86r-29,0r0,-252r29,0v7,59,-23,158,40,159v28,0,45,-19,52,-42r0,-117r29,0v2,60,-5,129,6,180r-20,0v-5,-8,-5,-21,-12,-27","w":198},"\u00b6":{"d":"123,-252r24,0r0,299r-24,0r0,-299xm13,-182v0,-45,27,-74,78,-70r0,299r-24,0r0,-159v-36,-3,-54,-33,-54,-70","w":177},"\u00b7":{"d":"48,-86v-12,1,-20,-9,-20,-21v0,-12,8,-20,20,-20v12,0,22,8,21,20v1,13,-8,22,-21,21","w":96},"\u00b8":{"d":"25,59v11,2,31,2,30,-13v0,-7,-10,-12,-31,-14r17,-32r21,0r-9,15v17,4,28,9,29,27v1,26,-31,39,-60,31","w":103},"\u00b9":{"d":"27,-159r38,0v1,-34,-2,-73,2,-104v-9,12,-24,19,-37,27r-10,-18r55,-37r15,0r0,132r34,0r0,22r-97,0r0,-22","w":142},"\u00ba":{"d":"72,-134v-38,0,-56,-23,-56,-61v0,-38,17,-61,56,-61v39,-1,56,23,56,61v0,38,-18,61,-56,61xm72,-235v-22,1,-29,13,-29,40v0,25,7,39,29,40v23,0,29,-16,29,-40v0,-24,-6,-40,-29,-40","w":144},"\u00bb":{"d":"93,-96r-58,82r-19,-16v17,-23,29,-49,52,-66v-24,-15,-37,-42,-54,-64r19,-15xm158,-96r-58,82r-19,-15v17,-23,29,-51,53,-67v-25,-15,-37,-42,-55,-64r19,-16","w":172},"\u00bc":{"d":"65,-101r2,-126v-9,12,-24,19,-37,27r-10,-18r55,-37r15,0r0,154r-25,0xm288,-35r-30,0r0,35r-24,0r0,-35r-74,0r0,-13r82,-109r16,0r0,101r30,0r0,21xm234,-56v-1,-21,1,-48,1,-64v-12,26,-28,48,-48,66v14,-2,31,-2,47,-2xm233,-257r19,13r-175,248r-19,-13","w":301},"\u00bd":{"d":"65,-101r2,-126v-9,12,-24,19,-37,27r-10,-18r55,-37r15,0r0,154r-25,0xm192,-140v28,-21,98,-22,93,28v-5,47,-36,71,-64,95v18,-8,45,-6,71,-6r0,23r-104,0r0,-12v26,-25,68,-52,72,-96v3,-31,-43,-24,-60,-12xm233,-257r19,13r-175,248r-19,-13","w":306},"\u00be":{"d":"302,-35r-30,0r0,35r-24,0r0,-35r-74,0r0,-13r82,-109r16,0r0,101r30,0r0,21xm248,-56v-1,-21,1,-48,1,-64v-12,26,-28,48,-48,66v14,-2,31,-2,47,-2xm33,-127v21,11,67,12,67,-20v0,-26,-27,-27,-55,-26v8,-28,30,-42,48,-60v-18,4,-43,3,-65,3r0,-22r92,0r0,12v-15,17,-28,37,-46,51v29,-5,52,14,52,42v0,45,-58,59,-98,42xm247,-257r19,13r-175,248r-19,-13","w":315},"\u00bf":{"d":"13,18v0,-67,64,-70,66,-134r24,0v5,67,-55,73,-60,130v-4,47,67,42,91,22r10,22v-40,29,-131,27,-131,-40xm89,-143v-12,0,-20,-8,-20,-20v0,-12,7,-21,20,-21v13,0,22,9,22,21v0,12,-9,20,-22,20","w":156},"\u00c0":{"d":"112,-271r-27,0r-57,-35r0,-7r41,0xm150,-70r-92,0r-26,70r-29,0r95,-256r14,0r96,256r-32,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115"},"\u00c1":{"d":"140,-313r41,0r0,7v-28,12,-41,38,-83,35xm150,-70r-92,0r-26,70r-29,0r95,-256r14,0r96,256r-32,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115"},"\u00c2":{"d":"95,-313r22,0r46,37r0,7r-29,0v-10,-9,-23,-15,-28,-30v-6,14,-19,21,-30,30r-28,0r0,-8xm150,-70r-92,0r-26,70r-29,0r95,-256r14,0r96,256r-32,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115"},"\u00c3":{"d":"49,-283v25,-40,73,5,105,-15r9,15v-25,38,-79,-15,-106,15xm150,-70r-92,0r-26,70r-29,0r95,-256r14,0r96,256r-32,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115"},"\u00c4":{"d":"71,-269v-10,0,-19,-6,-19,-17v0,-11,9,-17,19,-17v11,0,19,6,19,17v0,11,-8,17,-19,17xm140,-269v-11,0,-19,-6,-19,-17v0,-11,8,-17,19,-17v10,0,19,6,19,17v0,11,-9,17,-19,17xm150,-70r-92,0r-26,70r-29,0r95,-256r14,0r96,256r-32,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115"},"\u00c5":{"d":"95,-247v-16,-2,-27,-12,-27,-29v1,-20,14,-31,37,-31v46,0,52,58,10,60r93,247r-32,0r-26,-70r-92,0r-26,70r-29,0xm67,-96r74,0v-13,-37,-29,-72,-37,-115v-8,43,-24,78,-37,115xm105,-292v-9,0,-15,7,-15,16v-1,9,5,14,15,14v9,0,18,-5,17,-14v0,-10,-7,-16,-17,-16"},"\u00c6":{"d":"142,-216v-15,46,-39,82,-61,120r61,0r0,-120xm142,-71r-77,0r-40,71r-33,0r149,-252r138,0r0,27r-107,0r0,82r98,0r0,27r-98,0r0,89r109,0r0,27r-139,0r0,-71","w":304},"\u00c7":{"d":"52,-126v-8,81,66,126,133,92r7,24v-13,10,-32,13,-53,14r-6,11v17,4,27,9,28,27v1,27,-32,39,-60,31v-5,-23,31,-5,34,-27v0,-7,-10,-12,-31,-14r15,-28v-67,-7,-97,-56,-99,-130v-3,-99,72,-151,168,-122r-7,27v-68,-28,-138,14,-129,95","w":205,"k":{" ":14,"\u00a0":14,"-":28,"\u00ad":28,"\u2013":28,"\u2014":28,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":10,"V":10,"W":2,"X":15,"Y":13,"\u00dd":13,"Z":9,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":15,"y":15,"\u00fd":15,"\u00ff":15,"w":14,"x":10,"z":8,"\u00c6":41,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"a":6,"m":6,"n":6,"p":6,"r":6,"s":6,"u":6,"\u00e6":6}},"\u00c8":{"d":"117,-271r-26,0r-57,-35r0,-7r41,0xm31,-252r137,0r0,27r-108,0r0,82r99,0r0,27r-99,0r0,89r110,0r0,27r-139,0r0,-252","w":192},"\u00c9":{"d":"119,-313r41,0r0,7v-28,12,-41,38,-84,35xm31,-252r137,0r0,27r-108,0r0,82r99,0r0,27r-99,0r0,89r110,0r0,27r-139,0r0,-252","w":192},"\u00ca":{"d":"87,-313r22,0r45,37r0,7r-29,0v-10,-9,-22,-16,-27,-30v-6,14,-19,21,-30,30r-29,0r0,-8xm31,-252r137,0r0,27r-108,0r0,82r99,0r0,27r-99,0r0,89r110,0r0,27r-139,0r0,-252","w":192},"\u00cb":{"d":"63,-269v-11,0,-20,-7,-20,-17v0,-23,39,-22,38,0v-1,10,-7,17,-18,17xm150,-286v0,23,-38,21,-38,0v0,-10,8,-17,19,-17v10,0,20,6,19,17xm31,-252r137,0r0,27r-108,0r0,82r99,0r0,27r-99,0r0,89r110,0r0,27r-139,0r0,-252","w":192},"\u00cc":{"d":"70,-271r-26,0r-57,-35r0,-7r41,0xm37,-252r30,0r0,252r-30,0r0,-252","w":104},"\u00cd":{"d":"78,-313r42,0r0,7v-28,12,-41,38,-84,35xm37,-252r30,0r0,252r-30,0r0,-252","w":104},"\u00ce":{"d":"42,-313r22,0r46,37r0,7r-29,0v-10,-9,-23,-15,-28,-30v-6,14,-19,21,-30,30r-28,0r0,-8xm37,-252r30,0r0,252r-30,0r0,-252","w":104},"\u00cf":{"d":"19,-269v-11,0,-20,-7,-20,-17v0,-23,39,-22,38,0v-1,10,-7,17,-18,17xm107,-286v0,22,-39,22,-39,0v0,-10,8,-17,19,-17v11,0,20,7,20,17xm37,-252r30,0r0,252r-30,0r0,-252","w":104},"\u00d0":{"d":"217,-128v2,103,-72,146,-185,128r0,-120r-32,0r0,-21r32,0r0,-111v20,-4,43,-3,67,-3v80,0,117,48,118,127xm185,-128v0,-72,-45,-112,-123,-98r0,85r53,0r0,21r-53,0r0,95v80,13,123,-27,123,-103","w":236,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d1":{"d":"64,-283v26,-40,74,5,106,-15r9,15v-25,39,-79,-14,-106,15xm196,4v-46,-69,-100,-130,-139,-205r-2,0v8,60,2,134,4,201r-28,0r0,-256r15,0v46,68,100,129,140,203r2,0v-8,-60,-2,-133,-4,-199r28,0r0,256r-16,0","w":242},"\u00d2":{"d":"148,-271r-27,0r-57,-35r0,-7r41,0xm123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d3":{"d":"149,-313r41,0r0,7v-28,12,-41,38,-83,35xm123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d4":{"d":"112,-313r22,0r46,37r0,7r-30,0v-10,-9,-22,-16,-27,-30v-6,14,-19,21,-30,30r-29,0r0,-8xm123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d5":{"d":"66,-283v25,-40,73,5,105,-15r9,15v-25,39,-79,-14,-106,15xm123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d6":{"d":"88,-269v-11,0,-20,-7,-20,-17v0,-23,40,-21,39,0v0,10,-8,17,-19,17xm176,-286v0,23,-39,22,-38,0v1,-10,7,-17,18,-17v11,0,20,7,20,17xm123,4v-75,0,-102,-54,-103,-130v-1,-77,31,-130,103,-130v75,0,102,54,103,130v1,77,-31,130,-103,130xm123,-230v-51,0,-72,44,-71,104v1,56,18,104,71,104v51,0,72,-44,71,-104v-1,-56,-18,-104,-71,-104","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d7":{"d":"46,-186r45,46r46,-46r18,19r-45,45r45,46r-18,19r-46,-46r-46,46r-18,-19r46,-46r-46,-45","w":181},"\u00d8":{"d":"226,-126v1,77,-31,129,-103,130v-26,0,-47,-7,-63,-20r-14,20r-19,-13r17,-24v-16,-23,-24,-55,-24,-93v-1,-77,31,-129,103,-130v28,-1,49,8,64,21r15,-22r19,13r-18,26v15,24,23,53,23,92xm123,-230v-73,-3,-85,105,-59,168r105,-148v-11,-10,-26,-20,-46,-20xm123,-22v72,3,84,-104,59,-167r-104,148v11,12,23,19,45,19","w":246,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"\u00d9":{"d":"147,-271r-27,0r-57,-35r0,-7r41,0xm121,-23v43,0,54,-24,54,-69r0,-160r29,0v-7,105,35,259,-83,255v-58,-2,-90,-24,-90,-81r0,-174r29,0r0,160v0,45,18,69,61,69","w":234},"\u00da":{"d":"140,-313r41,0r0,7v-28,12,-41,38,-83,35xm121,-23v43,0,54,-24,54,-69r0,-160r29,0v-7,105,35,259,-83,255v-58,-2,-90,-24,-90,-81r0,-174r29,0r0,160v0,45,18,69,61,69","w":234},"\u00db":{"d":"108,-313r22,0r46,37r0,7r-29,0v-10,-9,-23,-15,-28,-30v-6,14,-19,21,-30,30r-29,0r0,-8xm121,-23v43,0,54,-24,54,-69r0,-160r29,0v-7,105,35,259,-83,255v-58,-2,-90,-24,-90,-81r0,-174r29,0r0,160v0,45,18,69,61,69","w":234},"\u00dc":{"d":"84,-269v-11,0,-20,-6,-20,-17v0,-11,9,-17,20,-17v11,0,18,7,18,17v0,10,-7,17,-18,17xm152,-269v-11,0,-19,-6,-19,-17v0,-11,8,-17,19,-17v10,0,19,6,19,17v0,11,-9,17,-19,17xm121,-23v43,0,54,-24,54,-69r0,-160r29,0v-7,105,35,259,-83,255v-58,-2,-90,-24,-90,-81r0,-174r29,0r0,160v0,45,18,69,61,69","w":234},"\u00dd":{"d":"128,-313r41,0r0,7v-28,12,-41,38,-84,35xm86,-100r-83,-152r35,0v21,45,50,81,65,132v15,-50,43,-87,63,-132r32,0r-82,152r0,100r-30,0r0,-100","w":200,"k":{"\u00f6":31,"\u00f5":31,"\u00ef":22,"\u00ee":22,"\u00ec":22,"\u00eb":31,"\u00e8":31,"\u00e1":22," ":9,"\u00a0":9,"*":-9,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,",":39,".":39,"\u2026":39,"C":15,"G":15,"O":15,"Q":15,"\u00c7":15,"\u00d2":15,"\u00d3":15,"\u00d4":15,"\u00d5":15,"\u00d6":15,"\u00d8":15,"T":4,"X":10,"Z":9,"c":31,"e":31,"g":31,"o":31,"q":31,"\u00e7":31,"\u00e9":31,"\u00ea":31,"\u00f0":31,"\u00f2":31,"\u00f3":31,"\u00f4":31,"\u00f8":31,"t":14,"v":17,"y":17,"\u00fd":17,"\u00ff":17,"w":14,"x":22,"z":23,"\u00c6":35,"\"":-13,"'":-13,"\u2018":-13,"\u2019":-13,"\u201c":-13,"\u201d":-13,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26,"\u00e0":22,"\u00e2":22,"\u00e3":22,"\u00e4":22,"\u00e5":22,"\u00ed":22,"\u00f1":22,"\u00f9":22,"\u00fa":22,"\u00fb":22,"\u00fc":22}},"\u00de":{"d":"188,-177v0,68,-60,90,-128,81r0,96r-29,0r0,-288r29,0r0,34v69,-6,128,9,128,77xm156,-177v0,-49,-49,-56,-96,-50r0,105v51,4,96,-3,96,-55","w":201,"k":{" ":14,"\u00a0":14,",":47,".":47,"\u2026":47,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"T":6,"X":15,"Y":9,"\u00dd":9,"Z":10,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"x":13,"z":10,"\u00c6":40,"A":23,"\u00c0":23,"\u00c1":23,"\u00c2":23,"\u00c3":23,"\u00c4":23,"\u00c5":23,"a":13,"m":13,"n":13,"p":13,"r":13,"s":13,"u":13,"\u00e6":13,"\u00e0":13,"\u00e1":13,"\u00e2":13,"\u00e3":13,"\u00e4":13,"\u00e5":13,"\u00ec":13,"\u00ed":13,"\u00ee":13,"\u00ef":13,"\u00f1":13,"\u00f9":13,"\u00fa":13,"\u00fb":13,"\u00fc":13}},"\u00df":{"d":"120,-223v-19,-9,-54,-12,-54,16r-1,207r-29,0r0,-155r-28,0r0,-25r28,0v-10,-63,37,-89,90,-67xm104,-33v22,12,89,25,84,-16v-6,-47,-87,-26,-87,-85v0,-57,72,-59,111,-39r-6,24v-20,-10,-82,-22,-76,14v8,45,87,22,87,85v0,60,-80,64,-122,41","w":232},"\u00e0":{"d":"124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30xm110,-206r-16,0r-41,-46r0,-7r34,0","w":178},"\u00e1":{"d":"124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30xm86,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":178},"\u00e2":{"d":"86,-264r12,0r40,66r-26,0v-8,-14,-17,-28,-22,-45v-5,18,-14,32,-24,45r-24,0xm124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30","w":178},"\u00e3":{"d":"108,-218v-21,-3,-44,-27,-60,-3r-9,-15v11,-12,18,-20,35,-21v23,0,37,27,57,6r9,15v-9,10,-18,17,-32,18xm124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30","w":178},"\u00e4":{"d":"124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30xm55,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm124,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":178},"\u00e5":{"d":"90,-199v-19,0,-36,-13,-35,-32v0,-21,14,-33,35,-33v20,0,35,11,35,33v0,18,-16,33,-35,32xm90,-247v-9,1,-16,5,-16,16v0,9,8,15,16,15v9,-1,15,-5,15,-15v0,-10,-6,-16,-15,-16xm124,-122v6,-52,-64,-36,-90,-23r-9,-22v40,-24,127,-29,127,40v0,43,-6,92,3,128r-21,0v-4,-8,-3,-20,-10,-25v-21,38,-113,37,-110,-24v2,-53,53,-56,109,-55v1,-7,1,-13,1,-19xm44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30","w":178},"\u00e6":{"d":"44,-51v0,43,73,31,79,0r0,-30v-36,0,-79,-3,-79,30xm263,-14v-32,27,-113,24,-128,-16r-3,0v-20,41,-120,48,-118,-18v1,-53,53,-56,109,-55v3,-33,0,-57,-36,-55v-20,1,-39,6,-53,13r-9,-22v28,-18,105,-28,119,8v10,-16,33,-24,57,-25v56,-3,74,40,66,97r-116,0v-10,62,61,82,101,52xm241,-110v8,-48,-45,-61,-74,-38v-9,7,-14,20,-15,38r89,0","w":286},"\u00e7":{"d":"48,-90v-10,60,54,86,93,56r9,22v-12,8,-26,14,-43,16r-7,11v17,4,28,9,29,27v1,26,-31,39,-60,31v-6,-23,32,-4,33,-27v0,-7,-10,-12,-31,-14r15,-28v-50,-4,-68,-39,-68,-94v0,-78,61,-114,129,-84r-8,25v-44,-22,-97,-8,-91,59","w":162,"k":{"y":4," ":9,"\u00a0":9,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"c":8,"e":8,"g":8,"o":8,"q":8,"\u00e7":8,"\u00e8":8,"\u00e9":8,"\u00ea":8,"\u00eb":8,"\u00f0":8,"\u00f2":8,"\u00f3":8,"\u00f4":8,"\u00f5":8,"\u00f6":8,"\u00f8":8,"x":6,"z":6,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5}},"\u00e8":{"d":"48,-87v-10,62,61,82,100,52r11,21v-13,12,-38,17,-62,18v-57,0,-79,-37,-79,-94v0,-58,26,-92,79,-94v56,-2,75,40,66,97r-115,0xm137,-110v7,-50,-45,-60,-74,-38v-9,7,-13,20,-15,38r89,0xm119,-206r-16,0r-41,-46r0,-7r34,0","w":182,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":4,"'":4,"\u2018":4,"\u2019":4,"\u201c":4,"\u201d":4}},"\u00e9":{"d":"48,-87v-10,62,61,82,100,52r11,21v-13,12,-38,17,-62,18v-57,0,-79,-37,-79,-94v0,-58,26,-92,79,-94v56,-2,75,40,66,97r-115,0xm137,-110v7,-50,-45,-60,-74,-38v-9,7,-13,20,-15,38r89,0xm105,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":182,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":4,"'":4,"\u2018":4,"\u2019":4,"\u201c":4,"\u201d":4}},"\u00ea":{"d":"88,-264r12,0r40,66r-26,0v-8,-14,-17,-28,-22,-45v-5,18,-14,32,-24,45r-24,0xm48,-87v-10,62,61,82,100,52r11,21v-13,12,-38,17,-62,18v-57,0,-79,-37,-79,-94v0,-58,26,-92,79,-94v56,-2,75,40,66,97r-115,0xm137,-110v7,-50,-45,-60,-74,-38v-9,7,-13,20,-15,38r89,0","w":182,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":4,"'":4,"\u2018":4,"\u2019":4,"\u201c":4,"\u201d":4}},"\u00eb":{"d":"48,-87v-10,62,61,82,100,52r11,21v-13,12,-38,17,-62,18v-57,0,-79,-37,-79,-94v0,-58,26,-92,79,-94v56,-2,75,40,66,97r-115,0xm137,-110v7,-50,-45,-60,-74,-38v-9,7,-13,20,-15,38r89,0xm60,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm129,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":182,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":4,"'":4,"\u2018":4,"\u2019":4,"\u201c":4,"\u201d":4}},"\u00ec":{"d":"34,-180r29,0r0,180r-29,0r0,-180xm62,-206r-16,0r-41,-46r0,-7r34,0","w":96},"\u00ed":{"d":"34,-180r29,0r0,180r-29,0r0,-180xm56,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":96},"\u00ee":{"d":"44,-264r11,0r40,66r-26,0v-8,-14,-16,-28,-21,-45v-5,18,-15,32,-25,45r-24,0xm34,-180r29,0r0,180r-29,0r0,-180","w":96},"\u00ef":{"d":"34,-180r29,0r0,180r-29,0r0,-180xm13,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm82,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":96,"k":{"\u2122":-11,"\u00ae":-11}},"\u00f0":{"d":"20,-90v-5,-73,71,-120,129,-77v-6,-25,-21,-46,-44,-56r-14,26r-17,-8r14,-25v-12,-4,-23,-4,-37,-4r0,-22v17,0,33,1,48,5r13,-22r16,8r-11,21v81,22,101,247,-15,248v-59,0,-78,-39,-82,-94xm104,-158v-39,1,-53,29,-54,68v-1,42,17,69,53,69v50,0,54,-64,48,-116v-9,-13,-25,-21,-47,-21","w":201},"\u00f1":{"d":"117,-218v-22,-3,-44,-26,-60,-3r-9,-15v11,-12,18,-21,35,-21v23,0,37,27,57,6r9,15v-9,10,-18,17,-32,18xm113,-184v85,0,53,108,59,184r-29,0v-7,-58,24,-157,-38,-159v-26,-1,-42,17,-48,36r0,123r-29,0r0,-180r20,0v3,7,1,18,7,22v11,-15,31,-26,58,-26","w":196},"\u00f2":{"d":"96,4v-56,0,-78,-37,-78,-94v0,-57,25,-94,78,-94v57,0,79,37,79,94v0,57,-26,94,-79,94xm145,-90v0,-39,-11,-68,-49,-69v-33,0,-48,23,-48,69v0,38,12,69,48,69v33,0,49,-23,49,-69xm114,-206r-16,0r-41,-46r0,-7r34,0","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00f3":{"d":"96,4v-56,0,-78,-37,-78,-94v0,-57,25,-94,78,-94v57,0,79,37,79,94v0,57,-26,94,-79,94xm145,-90v0,-39,-11,-68,-49,-69v-33,0,-48,23,-48,69v0,38,12,69,48,69v33,0,49,-23,49,-69xm103,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00f4":{"d":"93,-264r11,0r40,66r-26,0v-8,-14,-16,-28,-21,-45v-5,18,-14,32,-24,45r-24,0xm96,4v-56,0,-78,-37,-78,-94v0,-57,25,-94,78,-94v57,0,79,37,79,94v0,57,-26,94,-79,94xm145,-90v0,-39,-11,-68,-49,-69v-33,0,-48,23,-48,69v0,38,12,69,48,69v33,0,49,-23,49,-69","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00f5":{"d":"116,-218v-22,-3,-44,-27,-61,-3r-9,-15v11,-12,19,-20,35,-21v23,0,37,27,57,6r9,15v-9,10,-17,17,-31,18xm96,4v-56,0,-78,-37,-78,-94v0,-57,25,-94,78,-94v57,0,79,37,79,94v0,57,-26,94,-79,94xm145,-90v0,-39,-11,-68,-49,-69v-33,0,-48,23,-48,69v0,38,12,69,48,69v33,0,49,-23,49,-69","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00f6":{"d":"96,4v-56,0,-78,-37,-78,-94v0,-57,25,-94,78,-94v57,0,79,37,79,94v0,57,-26,94,-79,94xm145,-90v0,-39,-11,-68,-49,-69v-33,0,-48,23,-48,69v0,38,12,69,48,69v33,0,49,-23,49,-69xm62,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm131,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00f7":{"d":"14,-135r153,0r0,26r-153,0r0,-26xm91,-166v-12,1,-20,-9,-20,-21v0,-12,8,-20,20,-20v12,0,22,8,21,20v1,13,-8,22,-21,21xm91,-34v-12,1,-20,-9,-20,-21v0,-12,8,-20,20,-20v12,0,22,8,21,20v1,13,-8,22,-21,21","w":181},"\u00f8":{"d":"34,-25v-33,-56,-17,-159,62,-159v18,0,32,3,44,11r10,-12r18,13r-11,15v37,52,20,161,-61,161v-19,0,-34,-4,-46,-12r-9,13r-19,-14xm66,-32v44,33,93,-10,78,-80v-1,-7,-3,-13,-6,-19xm125,-149v-45,-30,-90,12,-76,80v1,7,3,12,5,18","w":192,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00f9":{"d":"84,4v-85,0,-53,-108,-59,-184r29,0r0,103v-1,32,4,57,35,56v28,0,40,-19,49,-39r0,-120r28,0v1,60,-4,127,4,180r-20,0v-4,-9,-2,-22,-9,-28v-12,18,-28,32,-57,32xm111,-206r-16,0r-41,-46r0,-7r34,0","w":194},"\u00fa":{"d":"84,4v-85,0,-53,-108,-59,-184r29,0r0,103v-1,32,4,57,35,56v28,0,40,-19,49,-39r0,-120r28,0v1,60,-4,127,4,180r-20,0v-4,-9,-2,-22,-9,-28v-12,18,-28,32,-57,32xm103,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":194},"\u00fb":{"d":"94,-264r11,0r40,66r-26,0v-8,-14,-16,-28,-21,-45v-5,18,-15,32,-25,45r-24,0xm84,4v-85,0,-53,-108,-59,-184r29,0r0,103v-1,32,4,57,35,56v28,0,40,-19,49,-39r0,-120r28,0v1,60,-4,127,4,180r-20,0v-4,-9,-2,-22,-9,-28v-12,18,-28,32,-57,32","w":194},"\u00fc":{"d":"84,4v-85,0,-53,-108,-59,-184r29,0r0,103v-1,32,4,57,35,56v28,0,40,-19,49,-39r0,-120r28,0v1,60,-4,127,4,180r-20,0v-4,-9,-2,-22,-9,-28v-12,18,-28,32,-57,32xm62,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm131,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":194},"\u00fd":{"d":"93,-29v10,-55,28,-101,42,-151r30,0r-66,196v-11,31,-29,70,-71,54r5,-25v28,7,37,-18,44,-45r-73,-180r33,0xm100,-259r32,0v-5,25,-25,34,-36,53r-17,0","w":167,"k":{" ":13,"\u00a0":13,"*":-5,",":26,".":26,"\u2026":26,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"\u00fe":{"d":"177,-94v2,71,-54,116,-120,91r0,75r-29,0r0,-324r29,0r1,90v10,-13,25,-22,48,-22v53,1,69,32,71,90xm147,-94v14,-67,-90,-92,-90,-27r0,90v41,28,100,-3,90,-63","w":194,"k":{"f":4,"*":5,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19,")":2,"]":2,"}":2}},"\u00ff":{"d":"93,-29v10,-55,28,-101,42,-151r30,0r-66,196v-11,31,-29,70,-71,54r5,-25v28,7,37,-18,44,-45r-73,-180r33,0xm49,-217v-10,0,-17,-7,-17,-18v0,-12,7,-18,17,-18v11,0,18,7,18,18v0,11,-7,18,-18,18xm118,-217v-10,0,-17,-8,-17,-18v0,-11,7,-17,17,-18v12,0,18,6,18,18v0,11,-6,18,-18,18","w":167,"k":{" ":13,"\u00a0":13,"*":-5,",":26,".":26,"\u2026":26,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"\u2013":{"d":"42,-117r153,0r0,27r-153,0r0,-27","w":237,"k":{" ":29,"\u00a0":29,"*":40,",":45,".":45,"\u2026":45,"T":30,"V":10,"X":29,"Y":5,"\u00dd":5,"Z":4,"\u00c6":16,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":13,"]":13,"}":13}},"\u2014":{"d":"42,-117r211,0r0,27r-211,0r0,-27","w":295,"k":{" ":29,"\u00a0":29,"*":40,",":45,".":45,"\u2026":45,"T":30,"V":10,"X":29,"Y":5,"\u00dd":5,"Z":4,"\u00c6":16,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":13,"]":13,"}":13}},"\u2018":{"d":"37,-240v12,-1,19,6,19,17v0,11,-8,18,-19,18v-36,0,-22,-62,-1,-70v9,-9,13,1,18,8v-10,6,-17,12,-17,27","w":69,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"v":-11,"y":-11,"\u00fd":-11,"\u00ff":-11,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u2019":{"d":"33,-255v41,6,18,71,-9,75r-9,-12v11,-6,17,-13,18,-28v-13,2,-19,-5,-19,-17v1,-11,7,-17,19,-18","w":69,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"v":-11,"y":-11,"\u00fd":-11,"\u00ff":-11,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u201c":{"d":"90,-240v12,-1,19,6,19,17v0,11,-8,18,-19,18v-36,0,-22,-62,-1,-70v9,-9,13,1,18,8v-10,6,-17,12,-17,27xm37,-240v12,-1,19,6,19,17v0,11,-8,18,-19,18v-36,0,-22,-62,-1,-70v9,-9,13,1,18,8v-10,6,-17,12,-17,27","w":122,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"v":-11,"y":-11,"\u00fd":-11,"\u00ff":-11,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u201d":{"d":"86,-255v41,6,18,71,-9,75r-9,-12v11,-6,17,-13,18,-28v-13,2,-19,-5,-19,-17v1,-11,7,-17,19,-18xm33,-255v41,6,18,71,-9,75r-9,-12v11,-6,17,-13,18,-28v-13,2,-19,-5,-19,-17v1,-11,7,-17,19,-18","w":122,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"v":-11,"y":-11,"\u00fd":-11,"\u00ff":-11,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u2026":{"d":"229,4v-13,0,-21,-9,-21,-21v0,-12,9,-20,21,-20v12,0,21,8,21,20v0,12,-8,21,-21,21xm138,4v-13,0,-21,-9,-21,-21v0,-12,9,-20,21,-20v12,0,21,8,21,20v0,12,-8,21,-21,21xm46,4v-12,1,-20,-9,-20,-21v0,-12,8,-20,20,-20v12,0,22,8,21,20v1,13,-8,22,-21,21","w":273,"k":{" ":11,"\u00a0":11,"*":51,"-":45,"\u00ad":45,"\u2013":45,"\u2014":45,",":-23,".":-23,"\u2026":-23,"T":11,"V":21,"W":10,"Y":5,"\u00dd":5,"v":9,"y":9,"\u00fd":9,"\u00ff":9,"w":8,"x":-7,"\u00c6":-14,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":6,"\u2122":6}},"\u2122":{"d":"140,-228r-49,0r0,106r-28,0r0,-106r-49,0r0,-24r126,0r0,24xm279,-220v-12,30,-29,55,-45,81r-12,0v-17,-25,-33,-52,-46,-81v5,29,4,64,4,98r-26,0r0,-130r28,0v16,27,35,51,48,81r46,-81r29,0r0,130r-28,0v-2,-34,3,-74,2,-98","w":318}}});
